
**Two factor** authentication is a **subset** of multifactor authentication (**MFA**).

### AAA Framework
- **Purpose**: Manages network access via three security functions:
    - **Authentication**: Identifies and verifies users.
    - **Authorization**: Defines what users can do once authenticated.
    - **Accounting**: Tracks user activities for billing, auditing, and reporting.
### Authentication
- **Methods**:
    - Passwords (something you know).
    - ID cards (something you have).
    - Biometric scans (something you are).
- **Multifactor Authentication (MFA)**: Requires two or more proofs of identity, such as a PIN and a token.
### Authorization
- **Functionality**:
    - Grants or restricts user access based on attributes.
    - Uses databases to define user capabilities.
    - Can be managed locally or via remote servers like RADIUS or TACACS+.
### Accounting
- **Purpose**:
    - Logs user activity, start/stop times, and resource usage.
    - Reports activities to centralized servers for analysis.

### Use Cases for AAA

**Network Access**
- Example: Remote VPN login processes involving authentication, authorization, and accounting.

**Administrative Access**
- Example: IT staff accessing routers with varying permission levels based on authentication.

### AAA Databases
- **Local AAA**:
    - Simple but not scalable.
    - Lacks support for accounting.
- **Centralized AAA**:
    - Easier management and updates.
    - Central repositories for accounting data.
    - Can integrate with systems like Active Directory or LDAP.

### AAA Protocols

#### RADIUS

- **Usage**: General-purpose protocol for network access and device administration.
- **Characteristics**:
    - Uses UDP ports 1812/1813.
    - Combines authentication and authorization.
    - Encrypts only the password.

#### TACACS+

- **Usage**: Often used for administrative access.
- **Characteristics**:
    - Uses TCP port 49.
    - Separates authentication, authorization, and accounting.
    - Encrypts the entire packet payload.

### AAA Servers
- **Purpose**: Centralize authentication, authorization, and accounting resources.
- ***Cisco Identity Services Engine (ISE)**:*
    - Supports TACACS+ and RADIUS.
    - Integrates with user repositories like Active Directory.
    - Provides additional features like profiling and web authentication.